#ifndef _ROUTINES_CPP
#define _ROUTINES_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "NSWFL.H"
#include "Entry.H"
#include "Init.H"
#include "WinService.H"
#include "Routines.H"

#include "../SockServer/SockServer.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char gsSessionLogDir[MAX_PATH];
char sExportFileTemp[MAX_PATH];
char gsServerAddress[255];

char gsAuthKey[MAX_AUTH_LENGTH];
char gsAuthString[MAX_AUTH_LENGTH];

char gsCompanyName[64];
char gsPassword[64];

char gsSQLDriver[255];
char gsSQLPassword[255];
char gsSQLServer[255];
char gsSQLUserID[255];
char gsSQLDatabase[255];

bool gbKillApplication = false;
bool gbApplicationRunning = false;
bool gbConnectNow = false;

int giServerPort = 0;

DWORD gdwConnectInterval = 0;
DWORD Timer_Thread_ID = 0;

HANDLE Timer_Thread_Handle = NULL;

FILE *gfhSessionLog = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetRegistryValues(void)
{
	DWORD iSizeofString = 0;

	iSizeofString = sizeof(gsSessionLogDir);
	memset(gsSessionLogDir, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SessionLogDir", gsSessionLogDir, iSizeofString))
        return false;
	
    iSizeofString = sizeof(gsServerAddress);
	memset(gsServerAddress, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ServerAddress", gsServerAddress, iSizeofString))
        return false;
	
    iSizeofString = sizeof(sExportFileTemp);
	memset(sExportFileTemp, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ExportFileTemp", sExportFileTemp, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsAuthKey);
	memset(gsAuthKey, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthKey", gsAuthKey, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsAuthString);
	memset(gsAuthString, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthString", gsAuthString, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsCompanyName);
	memset(gsCompanyName, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "CompanyName", gsCompanyName, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsPassword);
	memset(gsPassword, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "Password", gsPassword, iSizeofString))
        return false;
		
	iSizeofString = sizeof(gsSQLDriver);
	memset(gsSQLDriver, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLDriver", gsSQLDriver, iSizeofString))
        return false;
		
	iSizeofString = sizeof(gsSQLPassword);
	memset(gsSQLPassword, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLPassword", gsSQLPassword, iSizeofString))
        return false;
		
	iSizeofString = sizeof(gsSQLServer);
	memset(gsSQLServer, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLServer", gsSQLServer, iSizeofString))
        return false;
		
	iSizeofString = sizeof(gsSQLUserID);
	memset(gsSQLUserID, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLUserID", gsSQLUserID, iSizeofString))
        return false;
	
	iSizeofString = sizeof(gsSQLDatabase);
	memset(gsSQLUserID, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLDatabase", gsSQLDatabase, iSizeofString))
        return false;
	
	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ConnectInterval", gdwConnectInterval))
        return false;
	
	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ServerPort", (DWORD &)giServerPort))
        return false;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SaveRegistryValues(void)
{
	return true;
}	

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool OpenLogFile(void)
{
    char FullFileName[MAX_PATH];

    SYSTEMTIME ST;

    GetLocalTime(&ST);

    char DateTemp[64 + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, NULL, &ST, "MM-dd-yy", DateTemp,64);

    sprintf(FullFileName, "%s\\%s.txt", gsSessionLogDir, DateTemp);

    if( (gfhSessionLog = fopen(FullFileName, "ab")) == NULL)
        return false;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CloseLogFile(void)
{
	if(gfhSessionLog)
	{
		fclose(gfhSessionLog);
		return true;
	}
	else return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteSysLog(char *sMessage)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    char lsDate[64];
    char lsTime[64];
	char lsTemp[2048];

    GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &ST, NULL, lsDate, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, lsTime, 64);

	sprintf(lsTemp, "(%s %s) [*] %s", lsDate, lsTime, sMessage);
	fprintf(gfhSessionLog, "%s\r\n", lsTemp);
    InsertListBoxItem(MDI.LogList_hWnd, lsTemp, -1);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteLog(int iClientId, char *sMessage)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    char lsDate[64];
    char lsTime[64];
	char lsTemp[2048];

    GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &ST, NULL, lsDate, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, lsTime, 64);

	sprintf(lsTemp, "(%s %s) [%d] %s", lsDate, lsTime, iClientId, sMessage);
	fprintf(gfhSessionLog, "%s\r\n", lsTemp);
    InsertListBoxItem(MDI.LogList_hWnd, lsTemp, -1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool WaitOnApplicationToExit(void)
{
    gbKillApplication = true; // Tell application to exit

    if(gbIsMainDialogOpen)
    {
        EndDialog(MainDialog_hWnd, 0);
    }

    while(gbApplicationRunning) // Wait on application to exit
    {
        Sleep(1);
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Timer_Thread(LPVOID data)
{
    //if(gdwConnectInterval < 10)
        //gdwConnectInterval = 10;

    while(!gbKillApplication)
    {
        DWORD TimeCount = 0;

        while((TimeCount < (gdwConnectInterval * 60)) && !gbConnectNow)
        {
            Sleep(1000);
            TimeCount++;
        }

        gbConnectNow = false;

        if(ConnectToServer())
		{
			while(gServer.bcConnected[CCI.iThisClient])
			{
				Sleep(1);
			}
		}
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ConnectToServer(void)
{
	if(gServer.bcConnected[CCI.iThisClient])
	{
		WriteSysLog("Already connected.");
		return false;
	}

	if(gServer.DoConnect(gsServerAddress, giServerPort, &CCI.iThisClient))
	{
		WriteLog(gServer.icClientID[CCI.iThisClient], "Connected successfully.");
	}
	else{
		WriteSysLog("Failed to connect.");

		if(gServer.bcConnected[CCI.iThisClient])
		{
			WriteLog(gServer.icClientID[CCI.iThisClient], "Dropping a possible locked connection.");
			gServer.bcDisconnect[CCI.iThisClient] = true;
			return false;
		}

		return false;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CmdCmp(const char *sBuf, const char *sCmd)
{
	int iCmdLen = strlen(sCmd);
	if( strncmp(sBuf, sCmd, iCmdLen) == 0)
		return iCmdLen;
	else return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AppendDataToCmd(const char *sCmd, char *sData, int iDataSz, char *sOutBuf)
{
	int iRPos = 0;
	int iRWos = strlen(sCmd);

	strcpy(sOutBuf, sCmd);

	while(iRPos < iDataSz)
		sOutBuf[iRWos++] = sData[iRPos++];

	return iRWos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int BreakCmdFromData(const char *sBuf, int iCmdLen, int iBufSz, char *sOutBuf)
{
	int WPos = 0;
	int RPos = iCmdLen;

	while(RPos < iBufSz)
		sOutBuf[WPos++] = sBuf[RPos++];

	sOutBuf[WPos] = '\0';

	return WPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
